VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   7980
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   11160
   LinkTopic       =   "Form1"
   ScaleHeight     =   7980
   ScaleWidth      =   11160
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private Type PointDouble
  X As Double
  Y As Double
End Type

Private Type PointSingle
  X As Single
  Y As Single
End Type

Private Cairo As New cCairo

Private Sub Form_Load()
  Caption = "Click Me!"
End Sub

Private Sub Form_Click()

  Dim Srf As cCairoSurface
  'now we allocate a Surface, which matches with our Forms initial Client-Area
  Me.ScaleMode = vbPixels
  Set Srf = Cairo.CreateSurface(Me.ScaleWidth, Me.ScaleHeight, ImageSurface)
  
  
  Dim CC As cCairoContext
  Set CC = Srf.CreateContext
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  'PolyLines can be drawn as usual, directly from an Array of Points
  'the wrapper supports two differently "typed" Array-Containers, so
  'you can choose either the more "memory-efficient" Single-based Float-Types
  'for your X/Y Points - or alternatively also Arrays of Double-Float-Points,
  'to render your Shapes or X/Y-Curves from either one of these "Base-Containers"
  Dim i&, n&, ArrDoubles() As PointDouble, ArrSingles() As PointSingle
  Rnd -2
  n = 100
  ReDim ArrSingles(0 To n - 1)
  ReDim ArrDoubles(0 To n - 1)
  
  For i = 0 To n - 1
    ArrSingles(i).X = i * 7 'here we just increment x by a fixed distance, based on i
    ArrSingles(i).Y = Rnd * 80 'and put "randomness" only into the y-component of our "X/Y-graph"-array
    
    'just for testing, we simply copy/cast the single-members from the above array into the double-values
    'of our "higher-precision"-array, in our case, the curves should look identically later on
    ArrDoubles(i).X = ArrSingles(i).X
    ArrDoubles(i).Y = ArrSingles(i).Y
  Next i
  
  
  
  'Ok, now the drawing of these two arrays with identical content (aside from the precision of the array-members)
  CC.SetLineJoin CAIRO_LINE_JOIN_ROUND
  
  'first the Single-precision-Array
  CC.Save
    CC.TranslateDrawings 10, 10
    
    CC.PolygonSinglePtr VarPtr(ArrSingles(0)), UBound(ArrSingles) - LBound(ArrSingles) + 1
      CC.SetSourceColor vbBlack, 0.3
    CC.Stroke
    
    CC.PolygonSinglePtr VarPtr(ArrSingles(0)), UBound(ArrSingles) - LBound(ArrSingles) + 1, False, splNormal, True
      CC.SetSourceColor vbBlue, 0.4
    CC.Stroke
    
    CC.SelectFont "Arial", 12
    CC.TextOut 0, 85, "PolyLine from Single-Precision Points-Array (Blue = BSpline-interpolated Output from same Array)"
  CC.Restore
  
  
  'now we do the same with the Double-precision-Array
  CC.Save
    CC.TranslateDrawings 10, 160

    CC.PolygonPtr VarPtr(ArrDoubles(0)), UBound(ArrDoubles) - LBound(ArrDoubles) + 1
      CC.SetSourceColor vbBlack, 0.3
    CC.Stroke

    CC.PolygonPtr VarPtr(ArrDoubles(0)), UBound(ArrDoubles) - LBound(ArrDoubles) + 1, False, splNormal, True
      CC.SetSourceColor vbBlue, 0.5
    CC.Stroke

    CC.SelectFont "Arial", 12
    CC.TextOut 0, 85, "PolyLine from Double-Precision Points-Array (Blue = BSpline-interpolated Output from same Array)"
  CC.Restore


  'and finally a demonstration of the wrappers builtin "regular PolyShape-Drawing" (a few Examples with different Params)
  CC.Save
    CC.TranslateDrawings 10, 310
    CC.SetLineJoin CAIRO_LINE_JOIN_MITER
    
    'Pentagon
    CC.DrawRegularPolygon 50, 40, 50, 5
      CC.SetSourceColor vbRed, 0.5
    CC.Stroke

    'Pentagram
    CC.DrawRegularPolygon 160, 40, 50, 5, splNone, 17
      CC.SetSourceColor vbRed, 0.5
    CC.Stroke
    
    'Pentagram with applied Spline-Damping
    CC.DrawRegularPolygon 260, 40, 50, 5, splNormal, 17
      CC.SetSourceColor vbRed, 0.5
    CC.Stroke
    
    'filled square with applied Spline-Damping
    CC.DrawRegularPolygon 360, 40, 50, 4, splSmall
      CC.SetSourceColor vbMagenta, 0.5
    CC.Fill
    
    'filled Heptagram with applied Spline-Damping
    CC.DrawRegularPolygon 460, 40, 50, 7, splSmall, 5
      CC.SetSourceColor vbGreen, 0.5
    CC.Fill

    'filled Trigram (note, that all xxxx_grams need a defined Inner-Radius-parameter, otherwise we get a xxxx_gon ;-)
    CC.DrawRegularPolygon 560, 40, 50, 3, splNone, 6
      CC.SetSourceColor vbCyan, 0.3
    CC.Fill


    CC.SelectFont "Arial", 12
    CC.TextOut 0, 90, "Different regular Polygon-Shapes, please look at the varying Params in the Demo-Source"
  CC.Restore
  
  Srf.DrawToDC hDC
End Sub
